from Types import Insegnamento
from queryReader import QueryReader
from dbAPI import dbAPI
from typing import Dict, List, Set, Tuple
from customTypes import TipoInsegnamento
from getPolito import update_Insegnamenti_addNumStudenti
from dbToolbox import extractInsegnamentiParallelizzabili, db_updateListInsegnamenitInOrientamento_forAllCdl
from jotForm import JotFormReader


'''Il target di questo script è popolare il db predendo in input i file del GOF e i dati dal sito del Poli'''


excelFile:QueryReader = QueryReader("D:/Francesco/Scuola/Politecnico/Magistrale/Tesi/sources/2023/2023_Ins pd1_ICM_ETF_orari_estratto__V3.xlsx")
db:dbAPI = dbAPI()

writeDb:bool = True

# extract indisponibilità JOTFORM
# jotReader:JotFormReader = JotFormReader("D:/Francesco/Scuola/Politecnico/Magistrale/Tesi/sources/2023/JOTFORM.xlsx")
# jotReader.loadIndisponibilita()
# jotReader.merge()
# jotReader.printResults()
# jotReader.writeJsonStyle()
# exit(0)

# ins:List[Tuple[str,TipoInsegnamento]] = list()
# ins.append(("259328", TipoInsegnamento.ObbligatorioAScelta))
# ins.append(("261125", TipoInsegnamento.ObbligatorioAScelta))
# db.add_InsegnamentiInOrientamento("Cybersecurity", "INGEGNERIA INFORMATICA (COMPUTER ENGINEERING)", 'Z', '1-1', ins)
# exit(0)


if writeDb:
    print("delete all")
    db.delete_ALLForImportFromExcel()

# lettura excel
print("read query")
excelFile.readQuery()

excelFile.filter_PD_1()
excelFile.filter_primoAnnoTriennale()
excelFile.split_ID_INC_duplicates()

if writeDb:
    # Corso di Laurea
    print("insert cdl")
    excelFile.db_insertCdl()
    # Orientamenti
    print("insert Orientamenti")
    excelFile.db_insertOrientamenti()
    # Docenti
    print("insert Docenti")
    excelFile.db_insertDocenti()

# lista filtrata ma con tutti gl Item per ogni ID_INC
listInsegnamenti:List[Insegnamento] = excelFile.listInsegnamenti

if writeDb:
    # Insegnamento 1) (no nStudenti)
    # listNoDupInsegnamenti per insert in Insegnamento
    print("insert Insegnamenti 1)")
    listNoDupInsegnamento:List[Insegnamento] = excelFile.listInsegnamentiNoDup
    for ins in listNoDupInsegnamento:
        db.add_Insegnamento(int(ins.ID_INC),ins.numIscritti,ins.numIscritti,ins.id_collegio,ins.titolo,ins.cfu,0,ins.titolare)
        
    # Insegnamenti
    db.add_Insegnamento(-1, -1, -1, "", "Insegnamenti Primo Anno", 0, 0, "Docente titolare1")
    db.add_Insegnamento(-2, -1, -1, "", "Gestionle", 0, 0, "Docente titolare2")
    db.add_Insegnamento(-3, -1, -1, "", "Data Analisys And Art Int", 0, 0, "Docente titolare3")
    db.add_Insegnamento(-4, -1, -1, "", "Insegnamenti Vari", 0, 0, "Docente titolare4")
    db.add_Insegnamento(-5, -1, -1, "", "Insegnamenti Matematici", 0, 0, "Docente titolare5")
    db.add_Insegnamento(261402, -1, -1, "", "Insegnamenti Matematici", 0, 0, "Docente titolare5")
    
    # attesa risposta da Aldo
    db.add_Insegnamento(260275, 0, 0, "", "Computational linear algebra for large scale problems", 0, 0, "Berrone Stefano")

        
    # Insegnamento_listCodIns
    print("insert Insegnamento_listCodIns")
    mapID_INC_codIns:Dict[int,Set[str]] = excelFile.createCodInsUnique()
    for ID_INC in mapID_INC_codIns.keys():        
        for codIns in mapID_INC_codIns[ID_INC]:
            db.add_Insegnamento_codIns(ID_INC, codIns)

    # Docente_in_Insegnamento
    print("insert Docente_inInsegnamento")
    for ins in listNoDupInsegnamento:
        for docente in ins.docenti:
            if docente in ["DOCENTE", "Docente"]:
                continue
            db.add_DocenteInInsegnamento(docente, ins.ID_INC)

    # Insegnamento_in_Orientamento 1) (no nStudenti-non ci sono i dati, no tipoInsegnamento)
    print("insert Insegnamento_in_Orientamento 1)")
    listInsOrientamenti:Dict[str,Insegnamento] = excelFile.createOrientamentiUnique()
    for ins in listInsOrientamenti.keys():
        cdl = ins.split('_')[1]
        ID_INC = int(ins.split('_')[0])
        orient = ins.split('_')[2]
        db.add_InsegnamentoInOrientamento(ID_INC, orient, cdl, TipoInsegnamento.Sconosciuto, listInsOrientamenti[ins].tipo_laurea, 
                                        listInsOrientamenti[ins].pd, 0, listInsOrientamenti[ins].numAlfabetica, False)
    db.commit()

    # Insegnamento 2) nStudenti
    print("insert Insegnamenti 2) num studenti")
    update_Insegnamenti_addNumStudenti(False)
    
    # Insegnamento 3) info puntuali
    db.update_Insegnamento_setTitolare(259688, "Colet Cristina")
    db.update_Insegnamento_setTitolare(259401, "Punta Elisabetta")
    db.update_Insegnamento_setTitolare(260109, "Gay Nicoletta")
    db.update_Insegnamento_setTitolare(262447, "Zunino Claudio")
    # 262447 tit: Zunino Claudio || Rottondi Cristina Emma Margherita
    db.update_Insegnamento_setTitolare(260184, "Rizzo Giuseppe")
    db.update_Insegnamento_setTitolare(261907, "Scanzio Stefano")
    db.update_Insegnamento_setTitolare(263359, "Cena Gianluca")
    

    # Insegnamento_in_Orientamento 2) (+ tipoInsegnamento)
    print("insert InsegnamentoInOrientamento 2) tipoIns")
    db_updateListInsegnamenitInOrientamento_forAllCdl()
    
    # Inserimenti Orientamenti puntuali
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("261457", TipoInsegnamento.Obbligatorio))
    ins.append(("261456", TipoInsegnamento.Obbligatorio))
    ins.append(("258956", TipoInsegnamento.Obbligatorio))
    ins.append(("258955", TipoInsegnamento.Obbligatorio))
    ins.append(("258954", TipoInsegnamento.Obbligatorio))
    db.update_InsegnamentiInOrientamento("Percorso", "COMMUNICATIONS ENGINEERING", ins, 'Z', '1-1')
   
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("261402", TipoInsegnamento.TabellaAScelta))
    ins.append(("258972", TipoInsegnamento.TabellaAScelta))
    db.update_InsegnamentiInOrientamento("Percorso", "DATA SCIENCE AND ENGINEERING", ins, 'Z', '1-1')
   
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("260461", TipoInsegnamento.TabellaAScelta))
    ins.append(("258973", TipoInsegnamento.TabellaAScelta))
    ins.append(("258971", TipoInsegnamento.TabellaAScelta))
    db.update_InsegnamentiInOrientamento("Percorso", "DATA SCIENCE AND ENGINEERING", ins, 'Z', '2-1')
   
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("258950", TipoInsegnamento.Obbligatorio))
    ins.append(("261767", TipoInsegnamento.Obbligatorio))
    db.update_InsegnamentiInOrientamento("Percorso", "ICT FOR SMART SOCIETIES (ICT PER LA SOCIETA' DEL FUTURO)", ins, 'Z', '2-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("261157", TipoInsegnamento.Obbligatorio))   
    ins.append(("259206", TipoInsegnamento.Obbligatorio))   
    ins.append(("259205", TipoInsegnamento.Obbligatorio))   
    ins.append(("259204", TipoInsegnamento.Obbligatorio))   
    db.update_InsegnamentiInOrientamento("Wireless Integrated Circuits and Systems", "INGEGNERIA ELETTRONICA (ELECTRONIC ENGINEERING)", ins, 'Z', '1-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("258953", TipoInsegnamento.Obbligatorio))   
    db.update_InsegnamentiInOrientamento("Artificial Intelligence and Data Analytics", "INGEGNERIA INFORMATICA (COMPUTER ENGINEERING)", ins, 'Z', '1-1')
        
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("258953", TipoInsegnamento.CreditoLibero))   
    db.update_InsegnamentiInOrientamento("N4SIS - Nanotechnologies for Smart and Integrated Systems", "NANOTECHNOLOGIES FOR ICTs (NANOTECNOLOGIE PER LE ICT)", ins, 'Z', '1-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("259206", TipoInsegnamento.ObbligatorioAScelta))   
    ins.append(("260158", TipoInsegnamento.ObbligatorioAScelta))   
    ins.append(("259922", TipoInsegnamento.ObbligatorioAScelta))   
    db.update_InsegnamentiInOrientamento("PSRS - Photonics for Security, Reliability and Safety", "NANOTECHNOLOGIES FOR ICTs (NANOTECNOLOGIE PER LE ICT)", ins, 'Z', '2-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("259233", TipoInsegnamento.ObbligatorioAScelta))   
    ins.append(("260158", TipoInsegnamento.ObbligatorioAScelta))   
    ins.append(("259234", TipoInsegnamento.ObbligatorioAScelta))   
    db.update_InsegnamentiInOrientamento("Percorso", "COMMUNICATIONS AND COMPUTER NETWORKS ENGINEERING (INGEGNERIA TELEMATICA E DELLE COMUNICAZIONI)", ins, 'Z', '2-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("259233", TipoInsegnamento.ObbligatorioAScelta))   
    db.update_InsegnamentiInOrientamento("Percorso", "COMMUNICATIONS AND COMPUTER NETWORKS ENGINEERING (INGEGNERIA TELEMATICA E DELLE COMUNICAZIONI)", ins, 'Z', '2-1')
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("260302", TipoInsegnamento.ObbligatorioAScelta))   
    db.add_InsegnamentiInOrientamento("Percorso", "COMMUNICATIONS AND COMPUTER NETWORKS ENGINEERING (INGEGNERIA TELEMATICA E DELLE COMUNICAZIONI)", 'Z', '2-1', ins)
        
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("261600", TipoInsegnamento.ObbligatorioAScelta))   
    ins.append(("262962", TipoInsegnamento.ObbligatorioAScelta))   
    ins.append(("262897", TipoInsegnamento.ObbligatorioAScelta))   
    ins.append(("262241", TipoInsegnamento.ObbligatorioAScelta))   
    ins.append(("259669", TipoInsegnamento.ObbligatorioAScelta))   
    db.update_InsegnamentiInOrientamento("Percorso", "INGEGNERIA FISICA", ins, '1', '2-1')
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("258760", TipoInsegnamento.ObbligatorioAScelta))   
    ins.append(("262047", TipoInsegnamento.ObbligatorioAScelta))   
    ins.append(("262243", TipoInsegnamento.ObbligatorioAScelta))   
    db.add_InsegnamentiInOrientamento("Percorso", "INGEGNERIA FISICA", '1', '2-1', ins)
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("259034", TipoInsegnamento.CreditoLibero))   
    ins.append(("259036", TipoInsegnamento.CreditoLibero))   
    ins.append(("263333", TipoInsegnamento.CreditoLibero))   
    db.update_InsegnamentiInOrientamento("Percorso", "INGEGNERIA FISICA", ins, '1', '3-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("263333", TipoInsegnamento.CreditoLibero))   
    db.update_InsegnamentiInOrientamento("Percorso", "INGEGNERIA INFORMATICA", ins, '1', '3-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("263333", TipoInsegnamento.CreditoLibero))   
    db.update_InsegnamentiInOrientamento("Percorso", "INGEGNERIA INFORMATICA (COMPUTER ENGINEERING)", ins, '1', '3-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("263333", TipoInsegnamento.CreditoLibero))   
    db.update_InsegnamentiInOrientamento("Percorso", "INGEGNERIA ELETTRONICA", ins, '1', '3-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("263333", TipoInsegnamento.CreditoLibero))   
    db.update_InsegnamentiInOrientamento("Percorso", "INGEGNERIA DEL CINEMA E DEI MEZZI DI COMUNICAZIONE", ins, '1', '3-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("263333", TipoInsegnamento.CreditoLibero))   
    db.update_InsegnamentiInOrientamento("Percorso", "ELECTRONIC AND COMMUNICATIONS ENGINEERING (INGEGNERIA ELETTRONICA E DELLE COMUNICAZIONI)", ins, '1', '3-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("259878", TipoInsegnamento.TabellaAScelta))
    db.add_InsegnamentiInOrientamento("N4SIS - Nanotechnologies for Smart and Integrated Systems", "NANOTECHNOLOGIES FOR ICTs (NANOTECNOLOGIE PER LE ICT)", 'Z', '1-1', ins)
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("260275", TipoInsegnamento.Obbligatorio))
    db.add_InsegnamentiInOrientamento("MNIS - Micro and Nanotechnologies for Integrated Systems", "NANOTECHNOLOGIES FOR ICTs (NANOTECNOLOGIE PER LE ICT)", 'Z', '1-1', ins)
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("260275", TipoInsegnamento.Obbligatorio))
    db.add_InsegnamentiInOrientamento("Electronic micro and nanosystems", "INGEGNERIA ELETTRONICA (ELECTRONIC ENGINEERING)", 'Z', '2-1', ins)
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("258973", TipoInsegnamento.ObbligatorioAScelta))
    ins.append(("260178", TipoInsegnamento.ObbligatorioAScelta))
    ins.append(("258971", TipoInsegnamento.ObbligatorioAScelta))
    ins.append(("260738", TipoInsegnamento.ObbligatorioAScelta))
    ins.append(("260181", TipoInsegnamento.ObbligatorioAScelta))
    db.update_InsegnamentiInOrientamento("Percorso", "DATA SCIENCE AND ENGINEERING",ins, 'Z', '2-1')
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("260167", TipoInsegnamento.ObbligatorioAScelta))
    db.update_InsegnamentiInOrientamento("Percorso", "DATA SCIENCE AND ENGINEERING",ins, 'Z', '1-1')
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("261402", TipoInsegnamento.ObbligatorioAScelta))
    ins.append(("258972", TipoInsegnamento.ObbligatorioAScelta))
    ins.append(("260173", TipoInsegnamento.ObbligatorioAScelta))
    db.add_InsegnamentiInOrientamento("Percorso", "DATA SCIENCE AND ENGINEERING", 'Z', '1-1', ins)
    
    ins:List[Tuple[str,TipoInsegnamento]] = list()
    ins.append(("259328", TipoInsegnamento.ObbligatorioAScelta))
    ins.append(("261125", TipoInsegnamento.ObbligatorioAScelta))
    db.add_InsegnamentiInOrientamento("Cybersecurity", "INGEGNERIA INFORMATICA (COMPUTER ENGINEERING)", 'Z', '1-1', ins)
  
    
    # ins:List[Tuple[str,TipoInsegnamento]] = list()    
    # ins.append(("259675", TipoInsegnamento.Obbligatorio))
    # ins.append(("259233", TipoInsegnamento.Obbligatorio))
    # ins.append(("260158", TipoInsegnamento.Obbligatorio))
    # ins.append(("260159", TipoInsegnamento.Obbligatorio))
    # ins.append(("260160", TipoInsegnamento.Obbligatorio))
    # ins.append(("259791", TipoInsegnamento.Obbligatorio))
    # ins.append(("259223", TipoInsegnamento.Obbligatorio))
    # ins.append(("259234", TipoInsegnamento.Obbligatorio))
    # ins.append(("261618", TipoInsegnamento.Obbligatorio))
    # ins.append(("260198", TipoInsegnamento.TabellaAScelta))
    # ins.append(("261618", TipoInsegnamento.TabellaAScelta))
    # ins.append(("259791", TipoInsegnamento.TabellaAScelta))
    # db.add_InsegnamentiInOrientamento("Percorso", "COMMUNICATIONS AND COMPUTER NETWORKS ENGINEERING (INGEGNERIA TELEMATICA E DELLE COMUNICAZIONI)", 'Z', '2-1', ins)
    
    
# extract indisponibilità JOTFORM
jotReader:JotFormReader = JotFormReader("D:/Francesco/Scuola/Politecnico/Magistrale/Tesi/sources/2023/JOTFORM.xlsx")
jotReader.loadIndisponibilita()
jotReader.sort()
# jotReader.printResults()
jotReader.writeJsonStyle()
    
exit(0)



# list Insegnamenti obbligatori_a_scelta in oppure
extractInsegnamentiParallelizzabili()

# list Docenti titolari && list titolo Insegnamenti
listInsegnamenti = db.get_Insegnamenti()
s = str(set(map(lambda ins: ins[4], listInsegnamenti)))
s = s.replace("[","")
s = s.replace("]","")
s = s.replace("\'","")
s = s.replace("\n","")
s = s.replace(",","|")
print(s)
s = str(set(map(lambda ins: ins[7], listInsegnamenti)))
s = s.replace("[","")
s = s.replace("]","")
s = s.replace("\'","")
s = s.replace("\n","")
s = s.replace(",","|")
print(s)
